# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.monitor import MonitorManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestMonitorManagementScheduledQueryRulesOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(MonitorManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_scheduled_query_rules_create_or_update(self, resource_group):
        response = self.client.scheduled_query_rules.create_or_update(
            resource_group_name=resource_group.name,
            rule_name="str",
            parameters={
                "action": "action",
                "location": "str",
                "source": {"dataSourceId": "str", "authorizedResources": ["str"], "query": "str", "queryType": "str"},
                "autoMitigate": False,
                "createdWithApiVersion": "str",
                "description": "str",
                "displayName": "str",
                "enabled": "str",
                "etag": "str",
                "id": "str",
                "isLegacyLogAnalyticsRule": bool,
                "kind": "str",
                "lastUpdatedTime": "2020-02-20 00:00:00",
                "name": "str",
                "provisioningState": "str",
                "schedule": {"frequencyInMinutes": 0, "timeWindowInMinutes": 0},
                "tags": {"str": "str"},
                "type": "str",
            },
            api_version="2018-04-16",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_scheduled_query_rules_get(self, resource_group):
        response = self.client.scheduled_query_rules.get(
            resource_group_name=resource_group.name,
            rule_name="str",
            api_version="2018-04-16",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_scheduled_query_rules_update(self, resource_group):
        response = self.client.scheduled_query_rules.update(
            resource_group_name=resource_group.name,
            rule_name="str",
            parameters={"enabled": "str", "tags": {"str": "str"}},
            api_version="2018-04-16",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_scheduled_query_rules_delete(self, resource_group):
        response = self.client.scheduled_query_rules.delete(
            resource_group_name=resource_group.name,
            rule_name="str",
            api_version="2018-04-16",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_scheduled_query_rules_list_by_subscription(self, resource_group):
        response = self.client.scheduled_query_rules.list_by_subscription(
            api_version="2018-04-16",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_scheduled_query_rules_list_by_resource_group(self, resource_group):
        response = self.client.scheduled_query_rules.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2018-04-16",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
